# Virus Assassin
# Copyright 2002, Adam Fletcher <adamf+vA@csh.rit.edu>

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


import sys, string, os, glob, email, re, time
from xml.sax import saxutils
from xml.sax import make_parser
from xml.sax.handler import feature_namespaces
from email.Header import Header
from md5 import md5

def normalize_whitespace(text):
    "Remove redundant whitespace from a string"
    return ' '.join(text.split())

class ConfigData(saxutils.DefaultHandler):
    def __init__(self, workingDir, configFile):
        self.URI = workingDir + configFile
        self.configFile = configFile
        self.workingDir = workingDir
        self.inSignaturesDirTag = 0
        self.inDebugTag = 0
        self.inShowPerfTag = 0

    def loadConfigData(self):
        #print 'Loading config from: ', self.URI
        parser = make_parser()
        parser.setFeature(feature_namespaces, 0)
        parser.setContentHandler(self)
        parser.parse(self.URI)
        #print 'Finished loading config'

    def startElement(self, name, attrs):
        # print 'start element: ', name
        if name == 'signaturesDirectory':
            self.signaturesDirectory = ""
            self.inSignaturesDirTag = 1
        if name == 'debug':
            self.debug = 0
            self.inDebugTag = 1
        if name == 'showPerformance':
            self.showPerformance = 0
            self.inShowPerfTag = 1
        pass
    def endElement(self, name):
        # print 'end element: ', name
        if name == 'signaturesDirectory':
            self.signaturesDirectory = normalize_whitespace(self.signaturesDirectory)
            self.inSignaturesDirTag = 0
        if name == 'debug':
            self.inDebugTag = 0
        if name == 'showPerformance':
            self.inShowPerfTag = 0
        pass
    def error(self, exception):
        import sys
        sys.stderr.write("\%s\n" % exception)
    def characters(self, ch):
        if self.inSignaturesDirTag:
            self.signaturesDirectory = self.signaturesDirectory + ch
        if self.inDebugTag:
            if ch:
                self.debug = 1
        if self.inShowPerfTag:                        
            if ch:
                self.showPerformance = 1
                
class VirusSignature(saxutils.DefaultHandler):
    def __init__(self, signatureFile):
        self.signatureFile = signatureFile
        self.name = ""
        self.value = ""
        self.fileSize = ""
        self.fileName = ""
        self.description = ""
        self.fromHeader = ""
        self.returnPath = ""
        self.checksum = ""
        self.subject = ""
        self.bodyPatterns = []
        self.attachmentPatterns = []
        
        self.checkFileSize = 0
        self.checkFileName = 0
        self.checkSubject = 0
        self.checkChecksum = 0
        self.checkPattern = 0
        self.checkFrom = 0
        self.checkReturnPath = 0
        self.checkBody = 0
        self.checkHeaders = 0
        self.checkAttachments = 0

        # internal state for SAX parser
        self.inNameTag = 0
        self.inValueTag = 0
        self.inDescriptionTag = 0
        self.inHeaderTag = 0
        self.inBodyTag = 0
        self.inPatternsTag = 0
        self.inPatternTag = 0
        self.inFileNameTag = 0
        self.inFileSize = 0
        self.inChecksumTag = 0
        self.inOffsetTag = 0
        self.inStringTag = 0
        self.inAttachmentTag = 0
        self.inFromTag = 0
        self.inSubjectTag = 0
        self.inReturnPathTag = 0

        # state for handling offset, string groups etc
        self.lastString = ""
        self.lastOffset = ""
        
	
	
    def loadSignature(self):
#        print 'Loading signature from: ', self.signatureFile
        parser = make_parser()
        parser.setFeature(feature_namespaces, 0)
        parser.setContentHandler(self)
        parser.parse(self.signatureFile)
        self.internalCleanup()
#        print 'Finished loading signature: ', self.name


    def internalCleanup(self):
        self.inNameTag = 0
        self.inValueTag = 0
        self.inDescriptionTag = 0
        self.inHeaderTag = 0
        self.inBodyTag = 0
        self.inPatternsTag = 0
        self.inPatternTag = 0
        self.inFileNameTag = 0
        self.inFileSize = 0
        self.inChecksumTag = 0
        self.inOffsetTag = 0
        self.inStringTag = 0
        self.inAttachmentTag = 0
        self.inFromTag = 0
        self.inSubjectTag = 0
        self.inReturnPathTag = 0

        # state for handling offset, string groups etc
        self.lastString = ""
        self.lastOffset = ""
	
    def runTest(self, message):
        if self.checkPattern:
            pass

        if self.checkHeaders:
            if self.checkFrom: 
                fromHeader = message.get('From')
                fromHeader = re.sub('[<>]',' ',fromHeader)

                for possibleEmails in fromHeader.split():
                    if re.match('([A-Za-z0-9._-]+@[[A-Za-z0-9.-]+)',
                        possibleEmails):
                        if possibleEmails == self.fromHeader:
                            return self.value

            if self.checkReturnPath: 
                returnPath = message.get('Return-Path')
                returnPath = re.sub('[<>]',' ',returnPath)

                for possibleEmails in returnPath.split():
                    if re.match('([A-Za-z0-9._-]+@[[A-Za-z0-9.-]+)',
                        possibleEmails):
                        if possibleEmails == self.returnPath:
                            return self.value
            if self.checkSubject: 
                subject = message.get('Subject')
                #print 'got subject: ', subject

                if subject == self.subject:
                    return self.value


        if self.checkAttachments:
            if message.is_multipart():
                for payload in message.get_payload():
                    #print 'Found an attachment: ', payload.get_filename()
                    if self.checkFileSize: 
                        if len(payload.get_payload(decode=1)) == self.fileSize:
                            return self.value

                    if self.checkFileName: 
                        if self.fileName == payload.get_filename():
                            return self.value

                    if self.checkChecksum:
#                        if md5(payload.get_payload(decode=1)).digest() == self.checksum:
#                            return self.value
                        pass

                    for pattern in self.attachmentPatterns:
# we compile this here to avoid insertion of python code in the pattern
                        compiledPattern = re.compile(pattern[0])
                        decodedMessage = payload.get_payload(decode=1)
                        if compiledPattern.search(decodedMessage):
                            return self.value

        if self.checkBody:
            emailBody = message.get_payload()
            if message.is_multipart():
                emailBody = message.get_payload(0).as_string()

            for pattern in self.bodyPatterns:
# we compile this here to avoid insertion of python code in the pattern
                compiledPattern = re.compile(pattern[0])
                if compiledPattern.search(emailBody):
                    return self.value


        return 0

    def startElement(self, name, attrs):
        # print 'start element: ', name
        if name == 'name':
            self.inNameTag = 1
        if name == 'value':
            self.inValueTag = 1
        if name == 'description':
            self.inDescriptionTag = 1
        if name == 'header':
            self.inHeaderTag = 1
        if name == 'body':
            self.inBodyTag = 1
        if name == 'patterns':
            self.inPatternsTag = 1
        if name == 'pattern':
            self.inPatternTag = 1
        if name == 'fileName':
            self.inFileNameTag = 1
        if name == 'fileSize':
            self.inFileSize = 1
        if name == 'checksum':
            self.inChecksumTag = 1
        if name == 'offset':
            self.inOffsetTag = 1
        if name == 'string':
            self.inStringTag = 1
        if name == 'attachment':
            self.inAttachmentTag = 1
        if name == 'from':
            self.inFromTag = 1
        if name == 'returnPath':
            self.inReturnPathTag = 1
        if name == 'subject':
            self.inSubjectTag = 1
        pass
    
    def endElement(self, name):
        # print 'end element: ', name
        if name == 'name':
            self.inNameTag = 0
            self.name = normalize_whitespace(self.name)
        if name == 'value':
            self.value = normalize_whitespace(self.value)
            self.inValueTag = 0
        if name == 'description':
            self.description = normalize_whitespace(self.description)
            self.inDescriptionTag = 0
        if name == 'header':
            self.checkHeaders = 1
            self.inHeaderTag = 0
        if name == 'body':
            self.checkBody = 1
            self.inBodyTag = 0
        if name == 'patterns':
            self.inPatternsTag = 0
        if name == 'pattern':
            if self.inBodyTag:
                self.bodyPatterns.append((self.lastString, self.lastOffset))
            if self.inAttachmentTag:
                self.attachmentPatterns.append((self.lastString, self.lastOffset))

            # print 'Finished pattern, string: ', self.lastString, ' offset: ', self.lastOffset
            self.lastString = ""
            self.lastOffset = ""
            self.inPatternTag = 0
        if name == 'fileName':
            self.fileName = normalize_whitespace(self.fileName)
            #print 'fileName: ', self.fileName
            self.inFileNameTag = 0
        if name == 'fileSize':
            self.fileSize = normalize_whitespace(self.fileSize)
            self.inFileSize = 0
            #print 'fileSize: ', self.fileSize
        if name == 'checksum':
            self.checksum = normalize_whitespace(self.checksum)
            self.inChecksumTag = 0
            #print 'checksum: ', self.checksum
        if name == 'offset':
            self.lastOffset = normalize_whitespace(self.lastOffset)
            self.inOffsetTag = 0
        if name == 'string':
            self.lastString = normalize_whitespace(self.lastString)
            self.inStringTag = 0
        if name == 'attachment':
            self.checkAttachments = 1
            self.inAttachmentTag = 0
        if name == 'from':
            self.fromHeader = normalize_whitespace(self.fromHeader)
            self.inFromTag = 0
        if name == 'returnPath':
            self.returnPath = normalize_whitespace(self.returnPath)
            self.inReturnPathTag = 0
            #print 'returnPath: ', self.returnPath
        if name == 'subject':
            self.subject = normalize_whitespace(self.subject)
            self.inSubjectTag = 0

    def error(self, exception):
        import sys
        sys.stderr.write("\%s\n" % exception)
    def characters(self, ch):
        		
        if self.inNameTag:
            self.name = self.name + ch
            
        if self.inValueTag:
                self.value = self.value + ch
            
        if self.inDescriptionTag:
            self.description = self.description + ch
            
        if self.inPatternTag:
                self.checkPattern = 1

        if self.inFileNameTag:
                self.checkFileName = 1
                self.fileName = self.fileName + ch

        if self.inFileSize:
                self.checkFileSize = 1
                self.fileSize = self.fileSize + ch

        if self.inChecksumTag:
                self.checkChecksum = 1
                self.checksum = self.checksum + ch

        if self.inOffsetTag:
            self.lastOffset = self.lastOffset + ch
            
        if self.inStringTag:
                self.lastString = self.lastString + ch
             
        if self.inFromTag:
                self.checkFrom = 1
                self.fromHeader = self.fromHeader + ch
        if self.inReturnPathTag:
                self.checkReturnPath = 1
                self.returnPath = self.returnPath + ch

        if self.inSubjectTag:
            self.checkSubject = 1
            self.subject = self.subject + ch

if __name__ == '__main__':
    #print "Launching vA..."
    workingDir = "set me"

    if workingDir == "set me":
        print "You need to set working dir in va.py"
    else:
        configFile = "vaConfig.xml"
        signatures = []
        messageStr = ""

        configData = ConfigData(workingDir, configFile)
        configData.loadConfigData()
        filenames = glob.glob(configData.workingDir + configData.signaturesDirectory + '/*.xml')
               
        for filename in filenames:
            signature = VirusSignature(filename)
            signature.loadSignature()
            signatures.append(signature)


        while 1:
            data = sys.stdin.read(256)
            if data != '':
                messageStr = messageStr + data
            else:
                break


        message = email.message_from_string(messageStr)

        score = 0

        time.clock()

        for signature in signatures:
            score = score + signature.runTest(message)
            if score == 100:
                h = Header('Yes')
                message['X-vA-Infected'] = h
                break
        else:
            h = Header('No')
            message['X-vA-Infected'] = h


        h = Header('%d' % score)
        message['X-vA-Score'] = h


        h = Header('Yes; ' + '%f' % time.clock() )
        message['X-vA-Scanned'] = h

        print message.as_string()




